<?php

namespace App;

use App\Presenters\UseragentPresenter;
use App\Presenters\PresentsData;
use Illuminate\Database\Eloquent\Model;

class Useragent extends Model
{
    use PresentsData;

    protected $presenter = UseragentPresenter::class;

    protected $table = 'user_log_useragents';

    public $timestamps = false;

    protected $guarded = [];

    protected $casts = [
        'details' => 'object',
    ];

    /**
     * Device fullname accessor.
     *
     * @return string
     */
    public function getDeviceAttribute()
    {
        return $this->details->brand . ' ' . $this->details->model;
    }

    /**
     * OS fullname accessor.
     *
     * @return string
     */
    public function getOperationSystemAttribute()
    {
        return ($this->details->os->name ?? '') . ' ' . ($this->details->os->version ?? '') . ' ' . ($this->details->os->platform ?? '');
    }

    /**
     * Browser fullname accessor.
     *
     * @return string
     */
    public function getBrowserAttribute()
    {
        return ($this->details->client->name ?? '') . ' ' . ($this->details->client->version ?? '');
    }
}
