<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TrustedDevice extends Model
{
    protected $fillable = [
        'user_id',
        'ip_address',
        'user_agent',
        'trusted',
    ];

    protected $casts = [
        'trusted' => 'boolean',
    ];

    /**
     * Scope only trusted devices.
     *
     * @param $query
     * @return mixed
     */
    public function scopeTrusted($query)
    {
        return $query->where('trusted', 1);
    }

    /**
     * Relation with user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('\App\User');
    }

    /**
     * Relation with location.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function location()
    {
        return $this->belongsTo('\App\Location', 'ip_address', 'ip');
    }

    /**
     * Relation with useragent.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function useragent()
    {
        return $this->belongsTo('\App\Useragent', 'user_agent', 'useragent');
    }

    /**
     * Method to check whether device is trusted for user.
     *
     * @return mixed
     */
    public function isTrusted()
    {
        return $this->trusted;
    }
}
