<?php

namespace App;

use Carbon\Carbon;
use Digitick\Sepa\TransferFile\Factory\TransferFileFacadeFactory;
use App\Library\Billomat\BillomatClientHelper;

class Transfer extends CreditNote
{
    /**
     * @param $sum value from all open seller-operator-payments and fees
     * @return string name of the created file
     * @throws \Digitick\Sepa\Exception\InvalidArgumentException
     */
    public static function generateTransferCreditXml($sum)
    {
        $operatorAccountOwner = config('banking.accountOwner');
        $iban = config('banking.iban');
        $bic = config('banking.bic');

        $msgId = self::generateMsgId('transfer');
        $directDebit = TransferFileFacadeFactory::createCustomerCredit($msgId, $operatorAccountOwner, 'pain.001.003.03');

        $purpose = 'Umbuchung Portalgebuehren und Transaktionsgebuehren - ' . Carbon::now()->format('d.m.Y-h:i:s');
        $paymentId = $msgId;
        $directDebit->addPaymentInfo($paymentId, [
            'id' => $paymentId,
            'debtorName' => $operatorAccountOwner,
            'debtorAccountIBAN' => $iban,
            'debtorAgentBIC' => $bic,
        ]);

        $directDebit->addTransfer($paymentId, array(
            'amount' => $sum,
            'creditorIban' => config('banking.additionAccountNumber'),
            'creditorName' => $operatorAccountOwner,
            'remittanceInformation' => $purpose,
        ));

        $file = self::createTransferFileName($msgId);
        $xml = $directDebit->asXML();
        file_put_contents($file, $xml);
        return $msgId;
    }

    /**
     * Create storage directory and get file name for transfer writing
     *
     * @param $msgId
     * @return string
     */
    public static function createTransferFileName($msgId)
    {
        $path = storage_path('app/transfer');
        if (!file_exists($path)) {
            mkdir($path, 0770, true);
        }
        return $path . '/' . $msgId.  '.xml';
    }

    public function getSignedAmount()
    {
        return - $this->gross_amount;
    }

}