<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use App\Library\Billomat\BillomatClientHelper;
use SimpleXMLElement;

class SubscriptionRecurring extends AbstractModel
{
    public function invoices() {
        return $this->belongsToMany('App\Invoice');
    }
    
    public function user(){
        return $this->belongsTo('App\User');
    }
    
    
    /**
     * Erstellt Mitgliedsbeitrags Abo Rechnung
     * 
     * diese wird sowohl erstellt als auch als pdf abgelegt
     * 
     * @param \App\User $user
     * @param date $startdate Optionales Anfangsdatum
     * @param date $enddate Optionales Enddatum
     * @param (DAILY, WEEKLY, MONTHLY, YEARLY) $cycle 
     * @param int $cycle_num Zyklus offset ($cycle_num == 3 <=> alle 3 monate)
     * @return \App\Invoice
     */
    public static function createSubscriptionAbo(User $user, $startdate = null, $enddate = null, $cycle = null, $cycle_num = null){
        
        if( ! $user->hasBillomatAccount() ){
            $user->transferToBillomat();
        }
        
        if( $cycle == null ){
            $cycle = config('billomat.pdf.type.subscription.cycle');
        }
        
        if( $cycle_num == null ){
            $cycle_num = config('billomat.pdf.type.subscription.cycle_number');
        }

        $arr = [

            'client_id' => intval($user->billomat_id),

            'title' => config('billomat.pdf.type.subscription.title'),
            'name' => config('billomat.pdf.type.subscription.name'),
            'label' => config('billomat.pdf.type.subscription.label'),

            'action' => config('billomat.pdf.type.subscription.action'),

            'cycle' => $cycle,
            'cycle_number' => $cycle_num,

            'recurring-items' => [
                'recurring-item' => [
                    'unit' => 'stück',
                    'quantity' => 1.0,
                    'unit_price' => config('recoma.subscriptionfee'),
                    'title' => config('billomat.pdf.type.subscription.item.title'),
                    'description' => config('billomat.pdf.type.subscription.item.description'),
                ],
            ]
        ];
        
        if( config('billomat.pdf.type.subscription.templateid') !== 0 ){
            $arr['template_id'] = config('billomat.pdf.type.subscription.templateid');
        }
        
        if( $startdate !== null ){
            $arr['start_date'] = $startdate;
        }
        
        if( $enddate !== null ){
            $arr['end_date'] = $enddate;
        } else {
            if($startdate === null){
                $arr['end_date'] = date('Y-m-d', strtotime('+' . config('billomat.pdf.type.subscription.abo_length_month') . ' months'));
            } else {
                $arr['end_date'] = date('Y-m-d', strtotime($startdate . '+' . config('billomat.pdf.type.subscription.abo_length_month') . ' months'));
            }
        }
                
        $xml = BillomatClientHelper::array_to_xml($arr, "recurring");
        $res = BillomatClientHelper::sendAboRequest($xml);
        
        $subscriptionRecurring = new SubscriptionRecurring();
        $subscriptionRecurring->billomat_id = $res;
        $subscriptionRecurring->user_id = $user->id;
        $subscriptionRecurring->save();
        
        return $subscriptionRecurring;
        
    }
    
    public function createInvoice(){
        
        
        $invoice = new Invoice();
        $invoice->type = Invoice::TYPE_RECURRING;
        $invoice->coupon_id = Null;

        $invoice->transferAsRecurringInvoice($this->billomat_id, $this->user);
        $invoice->completeInvoice();
        
        $invoice->storePDF();
        $invoice->save();
        $this->invoices()->attach($invoice->id);
                       
        return $invoice;
    }
}
