<?php

namespace App\Sortings;

class DistanceSorting extends AbstractSorting
{
    public $param = 'distance';
    public $title = 'Am nächsten zuerst';

    /**
     * Method to apply sorting.
     *
     * @return Builder
     */
    public function apply()
    {
        return $this->builder->orderBy('distance');
    }

    /**
     * This sorting possible only if set lat and lon, and items filtered by distance.
     *
     * @return bool
     */
    public function isPossible()
    {
        if ( (float)request('lat') && (float)request('lon') ) {
            return true;
        }

        return false;
    }
}