<?php

namespace App\Sortings;

use App\Library\Utils;
use Illuminate\Database\Eloquent\Builder;

class AbstractSorting
{
    /**
     * Parameter in GET-query.
     *
     * @var string
     */
    public $param;

    /**
     * Title for frontend.
     *
     * @var string
     */
    public $title;

    /**
     * Flag is sorting current or not.
     *
     * @var boolean
     */
    public $current;

    /**
     * Link with other GET-params.
     *
     * @var string
     */
    public $link;

    /**
     * Query builder.
     *
     * @var Builder|null
     */
    protected $builder = null;

    /**
     * AbstractSorting constructor.
     *
     * @param Builder|null $builder
     */
    public function __construct(Builder $builder = null)
    {
        $this->builder = $builder;

        $this->initLink();
    }

    /**
     * Method to initialize sort link.
     */
    private function initLink()
    {
        $this->link = Utils::addParamsToURI(request()->fullUrl(), ['sort' => $this->param]);
    }

    /**
     * Method to check whether sorting is possible.
     *
     * @return bool
     */
    public function isPossible()
    {
        return true;
    }
}