<?php

namespace App;

use Digitick\Sepa\Exception\Exception;
use Illuminate\Database\Eloquent\Model;

class Shortlink extends Model
{
    const LINKAMOUNT = 100000000;
    const EXPIRATIONDATEINDAYS = 30;

    public static function createShortlink($link,$neverExpire=false)
    {
        $expirationDate = time() + 60 * 60 * 24 * self::EXPIRATIONDATEINDAYS;
        if($neverExpire){
            $expirationDate=null;//link läuft nicht ab
        }

        $shortLink = Shortlink::where('link', $link)->first();
        if ($shortLink) {
            $shortLink->expiration_date = $expirationDate;
            $shortLink->save();

            return $shortLink;
        }

        $queryLink = self::where('link', $link)->first();
        if ($queryLink) {
            $queryLink->expiration_date = $expirationDate;
            $queryLink->save();

            return $queryLink;
        }
        $queryReference = true;

        $i= 0; //safety in case of infinite loop
        while ($queryLink && $queryReference || $i < 5) {
            $shortLink = base_convert(random_int(1, self::LINKAMOUNT), 10, 36);
            $queryReference = self::where('shortlink', $shortLink)->first();

            if (!$queryLink && !$queryReference) {
                $instance = new Shortlink;
                $instance->shortlink = $shortLink;
                $instance->link = $link;
                $instance->expiration_date = $expirationDate;
                $instance->save();
                return $instance;
            }
            $i++;
        }
        throw new Exception('Could not find a free link code');
    }

    /**
     * Return the full shortened link
     */
    public function getFullShortLink($instance, $overrideValidityCheck = false)
    {
        $shortlink = $instance->shortlink;
        if (!$overrideValidityCheck) {
            self::checkIsValid($shortlink);
        }
        return url('-' . $shortlink);
    }

    /**
     * Return original Link based on shortlink.
     *
     * @param $shortlink
     * @return string
     * @throws \Exception
     */
    public static function getOriginalLink($shortlink)
    {
        $shortlink = self::where('shortlink', $shortlink)->first();

        if ( null === $shortlink ) {
            return route('home');
        }

        self::checkIsValid($shortlink->shortlink);
        return $shortlink->link;
    }

    /*
     *
     */
    public static function shorten($link,$neverExpire=false)
    {
        $instance = self::createShortlink($link,$neverExpire);
        return $instance->getFullShortLink($instance);
    }

    /*
     * Check if shortlink is Valid elsewise throw exception
     */
    public static function checkIsValid($shortlink)
    {
        $shortlinkRow = self::where('shortlink', $shortlink)->first();
        if ($shortlinkRow) {
            if ($shortlinkRow->expirationDate == null || $shortlinkRow->expiration_date > time()) {
                return true;
            } else {
                throw new \Exception('Link is expired');
            }
        } else {
            throw new \Exception('Link not valid');
        }
    }
}
