<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Session extends Model
{
    public $incrementing = false;

    /**
     * Relation with location.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function location()
    {
        return $this->belongsTo('\App\Location', 'ip_address', 'ip');
    }

    /**
     * Relation with useragent.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function useragent()
    {
        return $this->belongsTo('\App\Useragent', 'user_agent', 'useragent');
    }
}
