<?php

namespace App\Services;


use App\User;

class VerificationService
{
    private $user;

    /**
     * VerificationService constructor.
     * @param User $user
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Method to generate new verification token and send it to user e-mail.
     */
    public function sendEmailVerification()
    {
        $token = strtoupper(str_random(5));

        $this->user->email_verified = 0;
        $this->user->email_verification_token = $token;
        $this->user->save();

        $url = route('email.activation', [
            'id' => $this->user->id,
            'token' => $token,
        ]);

        $this->user->sendMail('email_verification_link', ['url' => $url], true);
    }

    /**
     * Methdo to generate employee registration token and send to employee's e-mail.
     */
    public function sendEmailEmployeeRegistration()
    {
        $token = strtoupper(str_random(5));

        $this->user->email_verified = 0;
        $this->user->email_verification_token = $token;
        $this->user->save();

        $url = route('employee.activation', [
            'id' => $this->user->id,
            'token' => $token,
        ]);

        $this->user->sendMail('email_employee_activation_link', ['url' => $url], true);
    }
}