<?php

namespace App\Services;

use App\UsersGift;

class UsersGiftService
{
    /**
     * Users gift.
     */
    private $usersGift;

    /**
     * UsersGiftService constructor.
     * @param UsersGift|null $usersGift
     */
    public function __construct(UsersGift $usersGift = null)
    {
        $this->usersGift = $usersGift;
    }

    /**
     * Method for creating new users gift.
     *
     * @param $giftId
     * @param $userId
     * @param $couponId
     */
    public function create($giftId, $userId, $couponId)
    {
        $usersGift = new UsersGift();

        $usersGift->gift_id   = $giftId;
        $usersGift->user_id   = $userId;
        $usersGift->coupon_id = $couponId;
        $usersGift->status    = UsersGift::STATUS_NEW;

        $usersGift->save();

        $this->usersGift = $usersGift;
    }

    /**
     * Method to set users gift as paid.
     *
     * @param $giftId
     * @param $userId
     * @param $couponId
     */
    public function setPaid($giftId, $userId, $couponId)
    {
        $ugift = UsersGift::where('gift_id', $giftId)
            ->where('user_id', $userId)
            ->where('coupon_id', $couponId)
            ->first();

        if ($ugift) {
            $ugift->status = UsersGift::STATUS_PAID;
            $ugift->save();
        }
    }

    /**
     * Method to set address and mark gift as ready to sending.
     *
     * @param $data
     */
    public function setAddress($data)
    {
        $this->usersGift->address_plz = $data['zip'];
        $this->usersGift->address_ort = $data['city'];
        $this->usersGift->address_str = $data['street'];
        $this->usersGift->address_num = $data['house'];
        $this->usersGift->address_add = $data['comment'];

        $this->usersGift->status = UsersGift::STATUS_READY;

        $this->usersGift->save();
    }

    /**
     * Method to makr users gift as received.
     */
    public function markAsReceived()
    {
        $this->usersGift->status = UsersGift::STATUS_RECEIVED;

        $this->usersGift->save();
    }
}