<?php

namespace App\Services;


use App\User;

class UserService
{
    private $user = null;

    /**
     * UserService constructor.
     * @param User|null $user
     */
    public function __construct(User $user = null)
    {
        $this->user = $user;
    }

    /**
     * Method to delete user.
     */
    public function delete()
    {
        $this->user->salutation          = '';
        $this->user->firstname           = 'Profil entfernt';
        $this->user->surname             = '';
        $this->user->email               = time() . '@reco.ma';
        $this->user->mobile              = '';
        $this->user->upload_portrait     = '';
        $this->user->status              = User::STATUS_DELETED;
        $this->user->billomat_id         = null;
        $this->user->alias               = $this->user->id;
        $this->user->api_token           = null;
        $this->user->paypal              = null;
        $this->user->email_temp          = null;
        $this->user->email_valid         = null;
        $this->user->paypal              = null;
        $this->user->tfa_code            = null;
        $this->user->tfa_code_expires_at = null;
        $this->user->google_tfa_secret   = null;

        $this->user->save();

        if ($this->user->account) {
            $this->user->account->street      = null;
            $this->user->account->housenumber = null;
            $this->user->account->zip         = null;
            $this->user->account->city        = null;
            $this->user->account->lat         = null;
            $this->user->account->lon         = null;
            $this->user->account->iban        = config('banking.iban');
            $this->user->account->iban_owner  = config('banking.accountOwner');
            $this->user->account->status      = User::STATUS_DELETED;

            $this->user->account->save();
        }
    }

    /**
     * Method to remove all sessions except current.
     */
    public function flushSessions()
    {
        $this->user->sessions()->where('id', '<>', session()->getId())->delete();
    }
}