<?php

namespace App\Services;


use DeviceDetector\DeviceDetector;

class UserAgentService
{
    private $deviceDetector;

    /**
     * UserAgentService constructor.
     *
     * @param $useragent
     */
    public function __construct($useragent)
    {
        $this->deviceDetector = new DeviceDetector($useragent);
        $this->deviceDetector->parse();
    }

    /**
     * Method to get client data.
     *
     * @return array|string
     */
    public function getClient()
    {
        return $this->deviceDetector->getClient();
    }

    /**
     * Method to get operation system data.
     *
     * @return array|string
     */
    public function getOs()
    {
        return $this->deviceDetector->getOs();
    }

    /**
     * Method to get device data.
     *
     * @return array|string
     */
    public function getDevice()
    {
        return $this->deviceDetector->getDeviceName();
    }

    /**
     * Method to get brand data.
     *
     * @return array|string
     */
    public function getBrand()
    {
        return $this->deviceDetector->getBrandName();
    }

    /**
     * Method to get model data.
     *
     * @return array|string
     */
    public function getModel()
    {
        return $this->deviceDetector->getModel();
    }

    /**
     * Method to get all parsed data.
     *
     * @return object
     */
    public function getAllData()
    {
        return (object)[
            'client' => $this->getClient(),
            'os'     => $this->getOs(),
            'device' => $this->getDevice(),
            'brand'  => $this->getBrand(),
            'model'  => $this->getModel(),
        ];
    }

    /**
     * Method to get all data as raw string.
     *
     * @return string
     */
    public function getLogString()
    {
        $browser = $this->getClient();
        $os      = $this->getOs();

        return
            ($browser['name'] ?? '') . ' ' . ($browser['version'] ?? '') . ' ' .
            ($os['name'] ?? '') . ' ' . ($os['version'] ?? '') . ' ' . ($os['platform'] ?? '') . ' ' .
            $this->getDevice() . ' ' .
            $this->getBrand() . ' ' .
            $this->getModel();
    }
}