<?php

namespace App\Services;


use App\Session;

class SessionService
{
    /**
     * Method to remove expired sessions.
     *
     * @param int $hours
     * @return mixed
     */
    public static function removeOld($hours = 24)
    {
        return Session::where('user_id', null)
            ->where('last_activity', '<', time() - $hours * 24 * 24)
            ->delete();
    }
}