<?php

namespace App\Services;


class SellerInvitationLinkService extends ReferralLinkService
{
    /**
     * Method to initialize link text according shareable content.
     */
    protected function initText()
    {
        if ($this->user) {
            $text = 'Ich lade Dich zu RECO.MA ein';

            $this->linkText = $text . '%0a' . $this->rawLink;
        } else {
            $this->linkText = $this->rawLink;
        }
    }

    /**
     * Method to get basic route (overriden).
     *
     * @param $alias
     * @return string
     */
    protected function getBasicRoute($alias)
    {
        return route('user.seller-invite-link', $alias);
    }
}