<?php

namespace App\Services;


use App\User;

class RouteService
{
    /**
     * Current user.
     *
     * @var User
     */
    private $user;

    /**
     * RouteService constructor.
     * @param User $user
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Method to get profile route.
     *
     * @return string
     */
    public function getProfileRoute()
    {
        if ( $this->user->hasRole('seller') || $this->user->hasRole('employee') ) {
            return route('seller.profile.index');
        } else {
            return route('user.profile');
        }
    }
}