<?php

namespace App\Services;


use App\Coupon;
use App\CreditNote;
use App\Transaction;
use App\User;

class PayOutService
{
    /**
     * @var User.
     */
    private $user;

    /**
     * @var Transactions to payout.
     */
    private $transactions;

    /**
     * @var Payout way (currently bank account or PayPal).
     */
    private $type;

    /**
     * PayOutService constructor.
     * @param $user
     * @param $transactions
     * @param $type
     */
    public function __construct($user, $transactions, $type)
    {
        $this->user         = $user;
        $this->transactions = $transactions;
        $this->type         = $type;
    }

    /**
     * Method to dispatch payout according to payout type.
     *
     * @return mixed
     */
    public function payOut()
    {
        $count = 0;

        foreach ($this->transactions as $transaction) {
            if ( !$transaction->isCredit() ) {
                continue;
            }

            if ( null === $transaction->credit_note || $transaction->credit_note->status !== CreditNote::STATUS_PAYMENT_REQUESTED ) {
                $creditNote = $transaction->createCreditNoteAndRequestPayment();
                $creditNote->payment_type = $this->type;
                if ('paypal' === $this->type) {
                    $creditNote->paypal_payer_id = $this->user->payPalData->payer_id;
                }
                $creditNote->save();

                $transaction->status = Transaction::STATUS_PAYMENT_REQUESTED;
                $transaction->save();

                if ($transaction->coupon->consumer->id === $this->user->id) {
                    (new CouponService($transaction->coupon))->setDone();
                }

                $count++;
            }
        }

        return $count;
    }
}