<?php

namespace App\Services;


use App\User;

class NewsletterService
{
    private $user;

    /**
     * NewsletterService constructor.
     * @param User $user
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Method to subscribe user to newsletter.
     */
    public function subscribe()
    {
        $this->user->newsletter = 1;
        $this->user->save();
    }

    /**
     * Method to unsubscribe user from newsletter.
     */
    public function unsubscribe()
    {
        $this->user->newsletter = 0;
        $this->user->save();
    }
}