<?php

namespace App\Services;


use App\CouponTemplate;
use App\User;

class MetaTagService
{
    /**
     * Method to return meta-tags for user registration form
     *
     * @param User|null $referrer
     * @param User|null $seller
     * @param CouponTemplate|null $deal
     * @return object
     */
    public static function userRegistrationForm(User $referrer = null, User $seller = null, CouponTemplate $deal = null)
    {
        // image
        $image = asset('img/logo_200x200.png');

        if ( null !== $seller ) {
            $image = asset($seller->account->logo200);
        }

        // title
        $title = 'RECO.MA';

        if ( null !== $seller ) {
            $title = $seller->account->company;
        }

        // description
        $descr = '';

        if ( null !== $referrer ) {
            $descr = $referrer->fullname . ' empfiehlt Dir ' . (null !== $seller ? $seller->account->company : 'RECO.MA') . '.';

            if ( null !== $deal ) {
                $descr .= ' Du erhältst bis zu ' . $deal->present()->discount_consumer_text . ' Cashback beim Einkauf, wenn Du der Empfehlung folgst.';
            }

            if ( $referrer->hasRole('seller') || $referrer->hasRole('employee') ) {
                $descr = (null !== $seller ? $seller->account->company : 'RECO.MA') . ' lädt Dich zu RECO.MA ein.';
                $deal = (new SellerService($seller))->getBestDeal('provision_agent');
                if ( null !== $deal && CouponTemplate::TYPE_NONE !== $deal->type_provision ) {
                    $descr .= ' Empfehle uns an Deine Freunde und erhalte bis zu ' . $deal->present()->provision_agent_text . ' Prämie.';
                } else {
                    $descr .= ' Empfehle uns an Deine Freunde und erhalte Prämie.';
                }
            }
        }

        return (object)[
            'image' => $image,
            'title' => $title,
            'descr' => $descr,
        ];
    }

    /**
     * Method to return meta-tags for seller registration form.
     *
     * @param User|null $referrer
     * @return object
     */
    public static function sellerRegistrationForm(User $referrer = null)
    {
        // image
        $image = asset('img/logo_200x200.png');

        // title
        $title = 'RECO.MA';

        // description
        $descr = '';

        if ( null !== $referrer ) {
            if ( $referrer->hasRole('seller') ) {
                $descr = $referrer->account->company . ' lädt Dich zu RECO.MA ein.';
            } else if ( $referrer->hasRole('employee') ) {
                $descr = $referrer->boss->account->company . ' lädt Dich zu RECO.MA ein.';
            } else {
                $descr = $referrer->fullname . ' lädt Dich zu RECO.MA ein.';
            }
        }

        return (object)[
            'image' => $image,
            'title' => $title,
            'descr' => $descr,
        ];
    }
}