<?php

namespace App\Services;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\Media;

class MediaService
{
    private $model;

    /**
     * MediaService constructor.
     * @param Model $model
     */
    public function __construct(Model $model)
    {
        $this->model = $model;
    }

    /**
     * Method to add draft videos to model.
     *
     * @param $video
     * @param string $collection
     * @return mixed
     */
    public function addVideo($video, $collection = 'videos_draft')
    {
        $this->model->clearMediaCollection($collection);

        return $this->model->addMedia($video)
            ->preservingOriginal()
            ->toMediaLibrary($collection);
    }

    /**
     * Method to add draft images to model.
     *
     * @param $image
     * @param string $collection
     * @return mixed
     */
    public function addImage($image, $collection = 'images_draft')
    {
        return $this->model->addMedia($image)
            ->preservingOriginal()
            ->toMediaLibrary($collection);
    }

    /**
     * Method to remove draft media items.
     *
     * @param $minutes
     * @return mixed
     */
    public static function removeDraft($minutes)
    {
        $media = Media::whereIn('collection_name', ['images_draft', 'videos_draft'])
            ->where('updated_at', '<=', Carbon::now()->subMinutes($minutes)->toDateTimeString())
            ->get();

        $mediaCount = $media->count();

        $media->each(function ($item) {
            $item->delete(); // delete each separately to fire observer event
        });

        return $mediaCount;
    }
}