<?php

namespace App\Services;

class LocationService
{
    private $token;

    /**
     * LocationService constructor.
     */
    public function __construct()
    {
        $this->init();
    }

    /**
     * Method to initialize service.
     */
    private function init()
    {
        $this->token = config('services.ipinfo.token');
    }

    /**
     * Method to get data by IP address.
     *
     * @param $ipAddress
     * @return bool|string
     */
    public function getDataByIPAddress($ipAddress)
    {
        return json_decode(file_get_contents('https://ipinfo.io/' . $ipAddress . '?token=' . $this->token));
    }
}