<?php
/**
 * Created by PhpStorm.
 * User: trr
 * Date: 22.08.17
 * Time: 16:26
 */

namespace App\Services;

use App\LinkInvitations;
use App\User;
use Auth;
use DB;

class LinkInvitationService
{
    private $user = null;

    public function __construct(User $user = null)
    {
        $this->user = $user;
    }

    public function create($reason, $couponTemplateId = null, $sharedAccountId = null, $isPermanentLink=false)
    {
        $user = $this->user;

        if (!$user) {
            $user = Auth::user();
        }

        $invitation = LinkInvitations::where('inviting_user_id', $user->id)
            ->where('reason', $reason)
            ->where('coupon_template_id', $couponTemplateId)
            ->where('shared_account_id', $sharedAccountId)
            ->first();

        if ($invitation) {
            return $invitation;
        }

        $invitation = new LinkInvitations();
        $token = $invitation->generateInvitationToken();

        $data = [
            'inviting_user_id' => $user->id,
            'reason' => $reason,
            'token' => $token,
            'coupon_template_id' => $couponTemplateId,
            'shared_account_id' => $sharedAccountId,
            'is_permanent_link' => $isPermanentLink
        ];

        $invitation->fill($data);
        $invitation->save();

        return $invitation;
    }
}