<?php

namespace App\Services;


class GoogleGeocodingService
{
    /**
     * Method to get coordinates by address.
     *
     * @param $zip
     * @param $city
     * @param $street
     * @param $housenumber
     * @param string $country
     * @return array|mixed|\stdClass
     */
    public static function getCoordinatesByAddress($zip, $city, $street, $housenumber, $country = 'Germany')
    {
        $url =
            'https://maps.googleapis.com/maps/api/geocode/json?address=' .
            urlencode($zip . '+' . $city . '+' . $street . '+' . $housenumber  . '+' . $country) .
            '&key=' . config('services.google_geocoding.key');

        return json_decode(file_get_contents($url));
    }
}