<?php

namespace App\Services;


use App\GeoAddress;

class GeoService
{
    /**
     * GeoService constructor.
     */
    public function __construct()
    {
        //
    }

    /**
     * Method to get special hash.
     *
     * @param $data
     * @return string
     */
    private function getHash($data)
    {
        return md5(strtolower($data->zip . $data->city . $data->street . $data->housenumber));
    }

    /**
     * Method to create geo address.
     *
     * @param $data
     * @param $geo
     * @return GeoAddress
     */
    private function createGeoAddress($data, $geo)
    {
        return GeoAddress::create([
            'hash'        => $this->getHash($data),
            'lat'         => $geo->results[0]->geometry->location->lat,
            'lon'         => $geo->results[0]->geometry->location->lng,
            'zip'         => $data->zip,
            'city'        => $data->city,
            'street'      => $data->street,
            'housenumber' => $data->housenumber,
        ]);
    }

    /**
     * Method to get cooridnates from address using Google API.
     *
     * @param $data
     * @return bool|object
     */
    private function getCoordinatesViaGoogle($data)
    {
        $geo = GoogleGeocodingService::getCoordinatesByAddress($data->zip, $data->city, $data->street, $data->housenumber);

        if (!$geo->results) {
            return false;
        }

        return $this->createGeoAddress($data, $geo);
    }

    /**
     * Method to get geo coordinates by address.
     *
     * @param $data
     * @return bool|object
     */
    public function getCoordinatesByAddress($data)
    {
        $data = (object)$data;

        if ( !$data->zip || !$data->city || !$data->street || !$data->housenumber ) {
            return false;
        }

        $geo = GeoAddress::where('hash', $this->getHash($data))->first();

        if (!$geo) {
            $geo = $this->getCoordinatesViaGoogle($data);
        }

        return $geo;
    }
}