<?php

namespace App\Services;

use App\Filters\GeoLocationFilter;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;

class FilterService
{
    /**
     * Initializing flag.
     *
     * @var bool
     */
    private static $initialized = false;

    /**
     * Filters collection.
     *
     * @var Collection
     */
    private static $filters;

    /**
     * Query builder
     *
     * @var Builder|null
     */
    private $builder = null;

    /**
     * FilterService constructor.
     *
     * @param Builder|null $builder
     */
    public function __construct(Builder $builder = null)
    {
        $this->builder = $builder;

        if (!self::$initialized) {
            $this->parseFilters();
        }
    }

    /**
     * Method to parse and build filters from request.
     */
    private function parseFilters()
    {
        self::$filters = collect([]);

        if ( (float)request('lat') && (float)request('lon') ) {
            self::$filters->push(new GeoLocationFilter());
        }

        self::$initialized = true;
    }

    /**
     * Method to get filter collection.
     *
     * @return mixed
     */
    public function getFilters()
    {
        return self::$filters;
    }

    /**
     * Method to apply all filters to Eloquent.
     *
     * @return Builder
     */
    public function apply()
    {
        foreach (self::$filters as $filter) {
            $this->builder = $filter->apply($this->builder);
        }

        return $this->builder;
    }

    /**
     * Method to get GeoLocationFilter if it defined.
     *
     * @return mixed
     */
    public function getGeoLocationFilter()
    {
        foreach (self::$filters as $filter) {
            if ( $filter instanceof GeoLocationFilter ) {
                return $filter;
            }
        }

        return null;
    }
}