<?php

namespace App\Services;


use App\TrustedDevice;

class DeviceService
{
    /**
     * DeviceService constructor.
     */
    public function __construct()
    {
        //
    }

    /**
     * Method to register device.
     *
     * @param $user
     * @param null $ip
     * @param null $useragent
     * @param bool $trusted
     */
    public function register($user, $ip = null, $useragent = null, $trusted = false)
    {
        // current IP address if not set
        if (null === $ip) {
            $ip = request()->ip();
        }

        // current useragent string if not set
        if (null === $useragent) {
            $useragent = request()->header('User-Agent');
        }

        // first logged device should be trusted
        if ( !$trusted && 0 === $user->devices()->trusted()->count() ) {
            $trusted = true;
        }

        // try to find this device
        $device = TrustedDevice::where('user_id', $user->id)
            ->where('ip_address', $ip)
            ->where('user_agent', $useragent)
            ->first();

        if ( null === $device ) { // if it doesn't yet exist
            TrustedDevice::create([
                'user_id'    => $user->id,
                'ip_address' => $ip,
                'user_agent' => $useragent,
                'trusted'    => $trusted,
            ]);
        }
    }

    /**
     * Method to get current user device.
     *
     * @param $user
     * @return mixed
     */
    public function current($user)
    {
        return TrustedDevice::where('user_id', $user->id)
            ->where('ip_address', request()->ip())
            ->where('user_agent', request()->header('User-Agent'))
            ->first();
    }

    /**
     * Method to trust current device.
     *
     * @param $user
     */
    public function trust($user)
    {
        $device = $this->current($user);
        $device->trusted = true;
        $device->save();
    }

    /**
     * Method to untrust current device.
     *
     * @param $user
     */
    public function untrust($user)
    {
        $device = $this->current($user);
        $device->trusted = false;
        $device->save();
    }
}