<?php

namespace App\Services;


use App\Transaction;
use App\User;
use App\Library\Facades\Format;

class DashboardService
{
    /**
     * Method to return account numbers, depended of user transactions and coupons.
     *
     * @param User $user
     * @return array
     */
    public function calculateTransactionsNumbers(User $user)
    {
        $sellerCoupons = $user->couponsSharedFromThisSeller;

        $transactions = $user->transactions->filter(function ($item) {
            return $item->status !== Transaction::STATUS_PAID;
        });

        return [
            'netto'    => Format::currency($sellerCoupons->sum('netto')),
            'consumer' => Format::currency($transactions->where('type', Transaction::TYPE_SELLER_CONSUMER_DISCOUNT_PAYMENT)->sum('amount') * -1),
            'agent'    => Format::currency($transactions->where('type', Transaction::TYPE_SELLER_AGENT_PROVISION_PAYMENT)->sum('amount') * -1),
            'recoma'   => Format::currency($transactions->where('type', Transaction::TYPE_SELLER_OPERATOR_PROVISION_PAYMENT)->sum('amount') * -1),
        ];
    }
}