<?php

namespace App\Services;


use App\Coupon;
use App\Events\CouponPaid;
use App\Events\CouponDone;
use App\Events\CouponRedeemed;
use Illuminate\Support\Facades\Auth;

class CouponService
{
    /**
     * Coupon.
     */
    private $coupon;

    /**
     * CouponService constructor.
     * @param Coupon|null $coupon
     */
    public function __construct(Coupon $coupon = null)
    {
        $this->coupon = $coupon;
    }

    /**
     * Method to mark coupon as paid.
     */
    public function setPaid()
    {
        $this->coupon->status = Coupon::STATUS_PAID;
        $this->coupon->save();

        event(new CouponPaid($this->coupon));

        activity(Auth::user())->register('coupon set as paid', null, null, Coupon::class, $this->coupon->id);
    }

    /**
     * Method to set coupon as done.
     */
    public function setDone()
    {
        $this->coupon->status = Coupon::STATUS_DONE;
        $this->coupon->save();

        event(new CouponDone($this->coupon));

        // TODO action log ???
    }

    /**
     * Method to redeem coupon.
     *
     * @param int $netto
     */
    public function redeem($netto = 0, $payment = 'cash')
    {
        $this->coupon->status      = Coupon::STATUS_REDEEMED;
        $this->coupon->netto       = $netto;
        $this->coupon->redeemer_id = Auth::user()->id;
        $this->coupon->save();

        event(new CouponRedeemed($this->coupon));

        $data = [
            'netto'   => $netto,
            'payment' => $payment,
        ];

        activity(Auth::user())->register('coupon redeemed', null, $data, Coupon::class, $this->coupon->id);
    }

    /**
     * Method to delete coupon.
     *
     * @throws \Exception
     */
    public function delete()
    {
        $this->coupon->delete();
    }
}