<?php
/**
 * Created by PhpStorm.
 * User: trr
 * Date: 22.08.17
 * Time: 16:26
 */

namespace App\Services;


use App\User;
use DB;

class ConsumerRegistrationService extends AbstractRegistrationService
{
    /**
     * Register:
     * Creates User/Account, assigns roles and gives permissions
     */
    public function register()
    {
        DB::transaction(function () {
            $this->create();
            $this->user->assignRole('agent');
            $this->user->assignRole('consumer');
            $this->user->givePermissionTo('edit account');
        });

        return $this->user;
    }

    public function sendDoubleOptInMail($user)
    {
        $token = $user->email_verification_token;
        $data['url'] = url('/activate', ['id' => $this->user->id, 'token' => $token]);

        $user->sendMail('confirm-registration-to-consumer', $data, true);
    }
}