<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Milon\Barcode\Facades\DNS1DFacade as DNS1D;
use Milon\Barcode\Facades\DNS2DFacade as DNS2D;

class BarCodeService
{
    private $code;

    /**
     * BarCodeService constructor.
     * @param $code
     */
    public function __construct($code)
    {
        $this->code = $code;
    }

    /**
     * Method to get barcode.
     *
     * @param string $type
     * @return mixed
     */
    public function getBarcode($type = 'C128')
    {
        $filePath = 'barcodes/' . $type . '/' . $this->code . '.png';

        if ( !Storage::exists($filePath) ) {
            Storage::put($filePath, DNS1D::getBarcodePNG($this->code, $type));
        }

        return 'data:image/png;base64,' . Storage::get($filePath);
    }

    /**
     * Method to get QR-code.
     *
     * @return string
     */
    public function getQRCode()
    {
        $filePath = 'qrcodes/' . $this->code . '.png';

        $url = route('seller.coupon.redeeming.index') . '?code=' . $this->code;

        if ( !Storage::exists($filePath) ) {
            Storage::put($filePath, DNS2D::getBarcodePNG($url, 'QRCODE'));
        }

        return 'data:image/png;base64,' . Storage::get($filePath);
    }
}