<?php
/**
 * Created by PhpStorm.
 * User: trr
 * Date: 22.08.17
 * Time: 16:26
 */

namespace App\Services;


use App\AccountConnection;
use App\User;
use DB;

class AgentRegistrationService extends AbstractRegistrationService
{
    /**
     * Register:
     * Creates User/Account, assigns roles and gives permissions
     */
    public function register()
    {
        DB::transaction(function () {
            $this->create();
            $this->user->assignRole('agent');
            $this->user->assignRole('consumer');
            $this->user->givePermissionTo('edit account');
            $this->user->account->onboarding_process_level = 5;
            $this->user->account->save();
        });

        return $this->user;
    }

    public function sendDoubleOptInMail($user)
    {
        $token = $user->email_verification_token;
        $data['url'] = url('/activate', ['id' => $this->user->id, 'token' => $token]);

        $user->sendMail('confirm-registration-to-agent', $data, true);
    }

    /**
     * Save connection between seller that invited the agent
     * @param $invitingUser
     */
    public function connectAgentWithSeller($invitingUser){
        AccountConnection::create([
            'account_id' => $this->account->id,
            'related_account_id' => $invitingUser->account->id,
            'type' => 'agent',
            'status' => 'active'
        ]);
    }
}