<?php

namespace App\Services;


use App\Activity;
use App\Coupon;
use App\CouponTemplate;
use App\Place;
use App\User;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ActivityService
{
    private $user;

    /**
     * ActivityService constructor.
     * @param User $user
     */
    public function __construct(User $user = null)
    {
        $this->user = $user;
    }

    /**
     * Method to get user activity log.
     *
     * @param int $limit
     * @param string $order
     * @return \Illuminate\Support\Collection
     */
    public function getActivity($limit = 100, $order = 'desc')
    {
        $rawData = $this->user->activity()->with('action');

        if ('desc' === $order) {
            $rawData->latest();
        }

        if ($limit) {
            $rawData->limit($limit);
        }

        $rawData = $rawData->get();

        $activity = collect([]);

        foreach ($rawData as $row) {
            $activity->push([
                'date' => $row->created_at->format('d.m.Y H:i'),
                'action' => trans('actions.' . $row->action->action),
            ]);
        }

        return $activity;
    }

    /**
     * Method to get users activity log.
     *
     * @param array $users
     * @param array $actions
     * @param null $minDate
     * @param null $maxDate
     * @param int $limit
     * @return string
     * @throws \Throwable
     */
    public function getDetailedActivity($users = [], $actions = [], $minDate = null, $maxDate = null, $limit = 25)
    {
        $activity = Activity::with('user', 'action', 'model') // eager loading for morph doesn't work in 5.2 !!!
            ->latest();

        if ($users) {
            $activity->whereIn('user_id', $users);
        } else {
            $activity->whereIn('user_id', $this->user->employees->pluck('id'));
        }

        if ($actions) {
            $activity->whereIn('action_id', $actions);
        }

        if ( null !== $minDate) {
            $activity->whereDate('created_at', '>=', $minDate);
        }

        if ( null !== $maxDate) {
            $activity->whereDate('created_at', '<=', $maxDate);
        }

        return view('redesign.back.metronic.employees.pieces.activity.list', [
            'results' => $activity->paginate($limit),
        ])->render();
    }
}