<?php

namespace App;

class Rating extends \willvincent\Rateable\Rating
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'rating',
        'user_id',
        'rateable_id',
        'description',
        'rateable_type',
        'rateable_user_type',
        'rated_account_id'
    ];

    const RATING_TITLES = [
        1 => 'Ungenügend',
        2 => 'Mangelhaft',
        3 => 'Akzeptabel',
        4 => 'Gut',
        5 => 'Hervorragend',
    ];

    public function account()
    {
        return $this->belongsTo('\App\Account', 'rated_account_id', 'id');
    }

    public function coupon()
    {
        switch ($this->rateable_type) {
            case 'coupon':
                return $this->belongsTo('\App\Coupon', 'rateable_id', 'id');
            default:
                return null;
        }
    }

    public function deal()
    {
        return $this->belongsTo('\App\CouponTemplate', 'rateable_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo('\App\User', 'user_id', 'id');
    }
}
