<?php

namespace App\Providers;

use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'App\Events\CouponRedeemed' => [
            'App\Listeners\CouponUsersSendMails',
        ],
        'App\Events\CouponPaid' => [
            'App\Listeners\UsersGiftCreate',
        ],
        'App\Events\CouponDone' => [
            'App\Listeners\CouponReleaseTransactions',
        ],
        'App\Events\CouponFinishedSellerTransactions' => [
            'App\Listeners\UsersGiftSetPaid',
        ],
        'App\Events\CouponFinishedClientTransactions' => [
            'App\Listeners\ReferralGotPaid',
        ],
        'App\Events\EmailChanged' => [
            'App\Listeners\EmailSendValidationToken',
        ],
        // employees
        'App\Events\EmployeeAdded' => [
            'App\Listeners\EmailSendActivationLink',
        ],
        'App\Events\EmployeeEdited' => [
            'App\Listeners\EmailResendActivationLink',
        ],
        // auth
        'Illuminate\Auth\Events\Login' => [
            'App\Listeners\LogSuccessfulLogin',
            'App\Listeners\RegisterDevice',
            //'App\Listeners\PreventUntrustedDevice',
        ],
        'Illuminate\Auth\Events\Logout' => [
            'App\Listeners\LogSuccessfulLogout',
        ],
        'Illuminate\Auth\Events\Failed' => [
            'App\Listeners\LogFailedAttempt',
        ],
        // simple tfa
        'App\Events\SimpleTokenGenerated' => [
            'App\Listeners\EmailSendSimpleToken',
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @param  \Illuminate\Contracts\Events\Dispatcher  $events
     * @return void
     */
    public function boot(DispatcherContract $events)
    {
        parent::boot($events);

        //
    }
}
