<?php

namespace App\Presenters;

use App\UsersGift;
use Illuminate\Support\HtmlString;

class UsersGiftPresenter extends AbstractPresenter
{
    /**
     * @var array Status badges.
     */
    private static $statusBadges = [
        UsersGift::STATUS_NEW      => 'secondary',
        UsersGift::STATUS_PAID     => 'primary',
        UsersGift::STATUS_READY    => 'info',
        UsersGift::STATUS_SENT     => 'primary',
        UsersGift::STATUS_RECEIVED => 'success',
    ];

    /**
     * @var array Status titles.
     */
    private static $statusTitles = [
        UsersGift::STATUS_NEW      => 'Erfasst',
        UsersGift::STATUS_PAID     => 'Bezahlt',
        UsersGift::STATUS_READY    => 'Versand fertig',
        UsersGift::STATUS_SENT     => 'Versendet',
        UsersGift::STATUS_RECEIVED => 'Erhalten',
    ];

    /**
     * Method to present gift.
     *
     * @return HtmlString
     */
    public function presentGift()
    {
        $route = route('gift-show', ['gift' => $this->entity->gift_id]);
        $name = $this->entity->gift->name;
        return new HtmlString('<a target="_blank" href="' . $route . '">' . $name . '</a>');
    }

    /**
     * Method to present user.
     *
     * @return HtmlString
     */
    public function presentUser()
    {
        $route = route('show-user-account', ['account' => $this->entity->user_id]);
        $name = $this->entity->user->firstname . ' ' . $this->entity->user->surname;
        return new HtmlString('<a target="_blank" href="' . $route . '">' . $name . '</a>');
    }

    /**
     * Method to present coupon.
     *
     * @return mixed
     */
    public function presentCoupon()
    {
        return $this->entity->coupon->present()->code;
    }

    /**
     * Method to present address.
     *
     * @return HtmlString
     */
    public function presentAddress()
    {
        $str =
            $this->entity->address_plz . ' ' .
            $this->entity->address_ort . ' ' .
            $this->entity->address_str . ' ' .
            $this->entity->address_num;
        $str .= $this->entity->address_add ? '<br>' . $this->entity->address_add : '';
        return new HtmlString($str);
    }

    /**
     * Method to present status.
     *
     * @return HtmlString
     */
    public function presentStatus()
    {
        $badge = self::$statusBadges[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>&nbsp;<span>' . $title . '</span>');
    }

    /**
     * Method to present status badge.
     *
     * @return HtmlString
     */
    public function presentStatusBadge()
    {
        $badge = self::$statusBadges[$this->entity->status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>');
    }
}