<?php

namespace App\Presenters;


class UseragentPresenter extends AbstractPresenter
{
    /**
     * Device icons (Font Awesome)
     *
     * @var array
     */
    private $deviceIcons = [
        'tablet'     => 'fas fa-tablet-alt',
        'phablet'    => 'fas fa-tablet-alt',
        'desktop'    => 'fas fa-desktop',
        'smartphone' => 'fas fa-mobile-alt',
        'console'    => 'fas fa-gamepad',
        'tv'         => 'fas fa-tv',
    ];

    /**
     * Default device icon (Font Awesome)
     *
     * @var string
     */
    private $defaultDeviceIcon = 'fas fa-desktop';

    /**
     * OS icons (Font Awesome)
     *
     * @var array
     */
    private $operationSystemIcons = [
        'Android'              => 'fab fa-android',
        'Windows'              => 'fab fa-windows',
        'Windows Phone'        => 'fab fa-windows',
        'iOS'                  => 'fab fa-apple',
        'Mac'                  => 'fab fa-apple',
        'Apple TV'             => 'fab fa-apple',
        'Ubuntu'               => 'fab fa-ubuntu',
        'Chrome OS'            => 'fab fa-chrome',
        'PlayStation'          => 'fab fa-playstation',
        'PlayStation Portable' => 'fab fa-playstation',
        'Chrome OS'            => 'fab fa-chrome',
    ];

    /**
     * Default OS icon (Font Awesome)
     *
     * @var string
     */
    private $operationSystemIcon = 'fas fa-microchip';

    /**
     * Method to present device icon.
     *
     * @return array|mixed
     */
    public function presentDeviceIcon()
    {
        $device = $this->entity->useragent->details->device ?? '';

        return isset($this->deviceIcons[$device]) ? $this->deviceIcons[$device] : $this->defaultDeviceIcon;
    }

    /**
     * Method to present device icon.
     *
     * @return array|mixed
     */
    public function presentOperationSystemIcon()
    {
        $os = $this->entity->useragent->details->os->name ?? '';

        return isset($this->operationSystemIcons[$os]) ? $this->operationSystemIcons[$os] : $this->operationSystemIcon;
    }
}