<?php

namespace App\Presenters;

use App\User;
use Carbon\Carbon;
use Illuminate\Support\HtmlString;

class UserPresenter extends AbstractPresenter
{
    /**
     * @var array Status titles.
     */
    public static $statusTitles = [
        User::STATUS_ACTIVE   => 'Aktiv',
        User::STATUS_DELETED  => 'Entfernt',
        User::STATUS_INACTIVE => 'Inaktiv',
        User::STATUS_PENDING  => 'Ausstehend',
        User::STATUS_DISABLED => 'Deaktiviert',
    ];

    /**
     * @var array Status badges.
     */
    public static $statusBadges = [
        User::STATUS_ACTIVE   => 'success',
        User::STATUS_DELETED  => 'dark',
        User::STATUS_INACTIVE => 'danger',
        User::STATUS_PENDING  => 'secondary',
        User::STATUS_DISABLED => 'dark',
    ];

    /**
     * @var array Referral status titles.
     */
    public static $referralStatusTitles = [
        User::REFERRAL_STATUS_NEW          => 'Neu',
        User::REFERRAL_STATUS_ACTIVE       => 'Aktiv',
        User::REFERRAL_STATUS_HAS_COUPONS  => 'RECO.BON Aktiv',
        User::REFERRAL_STATUS_HAS_REDEEMED => 'RECO.BON eingelöst',
        User::REFERRAL_STATUS_PAID         => 'RECO.BON bezahlt',
    ];

    /**
     * @var array Referral status badges (bootstrap 3, 4 compatible)
     */
    public static $referralStatusBadges = [
        User::REFERRAL_STATUS_NEW          => 'dark',
        User::REFERRAL_STATUS_ACTIVE       => 'secondary',
        User::REFERRAL_STATUS_HAS_COUPONS  => 'info',
        User::REFERRAL_STATUS_HAS_REDEEMED => 'primary',
        User::REFERRAL_STATUS_PAID         => 'success',
    ];

    /**
     * @var array Referral status badges
     */
    public static $referralStatusColors = [
        User::REFERRAL_STATUS_NEW          => 'dark',
        User::REFERRAL_STATUS_ACTIVE       => 'gray',
        User::REFERRAL_STATUS_HAS_COUPONS  => 'blue',
        User::REFERRAL_STATUS_HAS_REDEEMED => 'yellow',
        User::REFERRAL_STATUS_PAID         => 'green',
    ];

    /**
     * Method to present referral status.
     *
     * @return HtmlString
     */
    public function presentReferralStatus()
    {
        $color = self::$referralStatusColors[$this->entity->referral_status];
        $title = self::$referralStatusTitles[$this->entity->referral_status];
        return new HtmlString('<span class="status-badge status-badge-' . $color . '">' . $title . '</span>');
    }

    /**
     * Method to present status badge.
     *
     * @return HtmlString
     */
    public function presentReferralStatusBadge()
    {
        $badge = self::$referralStatusBadges[$this->entity->referral_status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>');
    }

    /**
     * Method to present creation date.
     *
     * @return string
     */
    public function presentCreationDate()
    {
        return Carbon::parse($this->entity->created_at)->format('d.m.Y');
    }

    /**
     * Method to present address.
     *
     * @return string
     */
    public function presentAddress()
    {
        return $this->entity->account->zip . ' ' . $this->entity->account->city . ', ' . $this->entity->account->street . ' ' . $this->entity->account->housenumber;
    }

    /**
     * Method to present status badge (metronic theme).
     *
     * @return HtmlString
     */
    public function presentStatusMetronic()
    {
        $badge = self::$statusBadges[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="kt-badge kt-badge--' . $badge . ' kt-badge--inline kt-badge--pill">' . $title . '</span>');
    }
}