<?php

namespace App\Presenters;

use App\Transaction;
use Carbon\Carbon;
use Illuminate\Support\HtmlString;
use App\Library\Facades\Format;

class TransactionPresenter extends AbstractPresenter
{
    /**
     * @var array Status titles.
     */
    public static $statusTitles = [
        Transaction::STATUS_PENDING           => 'Erfasst',
        Transaction::STATUS_ALLOCATED         => 'Auszahlbar',
        Transaction::STATUS_PAYMENT_REQUESTED => 'in Auszahlung',
        Transaction::STATUS_PAID              => 'Bezahlt',
    ];

    /**
     * @var array Status badges (bootstrap 3, 4 compatible)
     */
    public static $statusBadges = [
        Transaction::STATUS_PENDING           => 'secondary',
        Transaction::STATUS_ALLOCATED         => 'warning',
        Transaction::STATUS_PAYMENT_REQUESTED => 'primary',
        Transaction::STATUS_PAID              => 'success',
    ];

    /**
     * @var array Status colors
     */
    public static $statusColors = [
        Transaction::STATUS_PENDING           => 'gray',
        Transaction::STATUS_ALLOCATED         => 'yellow',
        Transaction::STATUS_PAYMENT_REQUESTED => 'blue',
        Transaction::STATUS_PAID              => 'green',
    ];

    /**
     * Method to present status.
     *
     * @return HtmlString
     */
    public function presentStatus()
    {
        $color = self::$statusColors[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="status-badge status-badge-' . $color . '">' . $title . '</span>');
    }

    /**
     * Method to present status (Bootstrap).
     *
     * @return HtmlString
     */
    public function presentStatusBootstrap()
    {
        $badge = self::$statusBadges[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>&nbsp;<span>' . $title . '</span>');
    }

    /**
     * Method to present status badge.
     *
     * @return HtmlString
     */
    public function presentStatusBadge()
    {
        $badge = self::$statusBadges[$this->entity->status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>');
    }

    /**
     * Method to present status badge (metronic theme).
     *
     * @return HtmlString
     */
    public function presentStatusMetronic()
    {
        $badge = self::$statusBadges[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="kt-badge kt-badge--' . $badge . ' kt-badge--inline kt-badge--pill">' . $title . '</span>');
    }

    /**
     * Method to present creation date.
     *
     * @return string
     */
    public function presentCreationDate()
    {
        return Carbon::parse($this->entity->created_at)->format('d.m.Y');
    }

    /**
     * Method to present amount.
     *
     * @return mixed
     */
    public function presentAmount()
    {
        return Format::currency($this->entity->amount * -1);
    }
}