<?php
namespace App\Presenters;

use App\Exceptions\PresenterNotFoundException;

trait PresentsData
{
    /**
     * View presenter instance
     *
     * @var AbstractPresenter
     */
    protected $presenterInstance;

    /**
     * Prepare a new or cached presenter instance
     *
     * @throws PresenterNotFoundException
     * @return AbstractPresenter
     */
    public function present()
    {
        $presenter_class_name = (!empty($this->presenter) ? $this->presenter : get_class($this) . 'Presenter');

        if (!class_exists($presenter_class_name, true)) {
            throw new PresenterNotFoundException($presenter_class_name);
        }

        if (!$this->presenterInstance) {
            $this->presenterInstance = new $presenter_class_name($this);
        }

        return $this->presenterInstance;
    }
}