<?php

namespace App\Presenters;


use App\Place;
use Illuminate\Support\HtmlString;

class PlacePresenter extends AbstractPresenter
{
    /**
     * @var array Status titles.
     */
    public static $statusTitles = [
        Place::STATUS_ACTIVE   => 'Aktiv',
        Place::STATUS_INACTIVE => 'Inaktiv',
    ];

    /**
     * @var array Status badges (bootstrap 3, 4 compatible)
     */
    public static $statusBadges = [
        Place::STATUS_ACTIVE   => 'success',
        Place::STATUS_INACTIVE => 'danger',
    ];

    /**
     * Method to present status.
     *
     * @return HtmlString
     */
    public function presentStatus()
    {
        $badge = self::$statusBadges[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>&nbsp;<span>' . $title . '</span>');
    }

    /**
     * Method to present status badge (metronic theme).
     *
     * @return HtmlString
     */
    public function presentStatusMetronic()
    {
        $badge = self::$statusBadges[$this->entity->status];
        $title = self::$statusTitles[$this->entity->status];
        return new HtmlString('<span class="kt-badge kt-badge--' . $badge . ' kt-badge--inline kt-badge--pill">' . $title . '</span>');
    }

    /**
     * Method to present status badge.
     *
     * @return HtmlString
     */
    public function presentStatusBadge()
    {
        $badge = self::$statusBadges[$this->entity->status];
        return new HtmlString('<span class="badge badge-pill badge-' . $badge . '">&nbsp;</span>');
    }

    /**
     * Method to present address.
     *
     * @return string
     */
    public function presentAddress()
    {
        return $this->entity->address;
    }
}