<?php

namespace App\Presenters;

abstract class AbstractPresenter
{
    /**
     * The resource that is the object that was decorated.
     *
     * @var mixed
     */
    protected $entity;

    /**
     * Language file fore this presenter.
     *
     * @var string
     */
    public static $langDomain;

    /**
     * @param $entity
     */
    public function __construct($entity)
    {
        $this->entity = $entity;
    }

    /**
     * Allow for property-style retrieval
     *
     * @param $property
     * @return mixed
     */
    public function __get($property)
    {
        if ( $this->presentMethodExists($property) ) {
            $method = $this->getPresentMethod($property);
            return $this->{$method}();
        }
        return $this->entity->{$property};
    }

    public function __isset($property)
    {
        return $this->presentMethodExists($property) || isset($this->entity->{$property});
    }

    /**
     * Allow for methods-style retrieval
     *
     * @param  string $name
     * @param  array  $arguments
     * @return mixed
     */
    public function __call($name, $arguments)
    {
        return call_user_func_array([$this->entity, $name], $arguments);
    }

    protected function presentMethodExists($property)
    {
        return method_exists($this, $this->getPresentMethod($property));
    }

    protected function getPresentMethod($property)
    {
        return 'present' . studly_case($property);
    }
}