<?php

namespace App\Policies;

use App\Place;
use App\User;

class PlacePolicy
{
    /**
     * Method to check whether the seller is owner of place.
     *
     * @param User $user
     * @param Place $place
     * @return bool
     */
    public function update(User $user, Place $place)
    {
        if ( $user->hasRole('employee') ) {
            $user = $user->boss;
        }

        return $user->id === $place->seller_id;
    }
}