<?php

namespace App\Policies;

use App\CouponTemplate;
use App\User;

class CouponTemplatePolicy
{
    /**
     * Method to check whether the user is owner of model.
     *
     * @param User $user
     * @param Model $model
     * @return bool
     */
    public function update(User $user, CouponTemplate $model)
    {
        if ( $user->hasRole('employee') ) {
            $user = $user->boss;
        }

        return $user->id === $model->user_id;
    }
}
