<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Presenters\PlacePresenter;
use App\Presenters\PresentsData;

class Place extends Model
{
    use PresentsData;

    protected $guarded = [];

    protected $presenter = PlacePresenter::class;

    const STATUS_ACTIVE   = 'active';
    const STATUS_INACTIVE = 'inactive';
    const STATUS_DELETED  = 'deleted';

    public function seller()
    {
        return $this->hasOne('\App\User', 'id', 'user_id');
    }

    public function deals()
    {
        // TODO bind through pivot table
    }

    /**
     * Check whether place is deleted.
     *
     * @return bool
     */
    public function isDeleted()
    {
        return self::STATUS_DELETED === $this->status;
    }

    /**
     * Address accessor.
     *
     * @return string
     */
    public function getAddressAttribute()
    {
        return $this->zip . ' ' . $this->city . ', ' . $this->street . ' ' . $this->housenumber;
    }
}