<?php namespace App\Observer;

use App\Exceptions\UnsupportedException;
use App\User;
use App\Library\Billomat\BillomatClientHelper;

use Carbon\Carbon;
use Phobetor\Billomat\Client\BillomatClient;

use Log;

class UserObserver {

    public function updating(User $user){
        if ($user->hasRole('seller') && $user->getOriginal('status') == 'active' && $user->status=='inactive') {
            throw new UnsupportedException('Der Status eines bereits aktiven Sellers kann nicht von Aktiv in Inaktiv geändert werden');
        }
    }

    public function updated(User $user){
        if ($user->isDirty($user::BILLOMAT_FIELDS)) {
            $user->updateInBillomat();
        }

        if(!$user->hasRole('employee') && $user->isDirty('status')){
            $user->account->update([
               'status'=>$user->status
            ]);
        }
    }
}

