<?php

namespace App\Observer;

use App\CreditNote;
use App\Transaction;
use Exception;

class TransactionObserver {

    public function created(Transaction $transaction){
        switch ($transaction->type){
            case Transaction::TYPE_AGENT_RECOMMENDATION_PROVISION_CREDIT:
                $this->creditNote($transaction);
                break;
        }
    }

    public function creditNote($transaction) {

        //Create Invoice
        $creditNote = new CreditNote();

        $creditNote->transaction_id = $transaction->id;
        $creditNote->user_id = $transaction->user_id; //Agent

        $creditNote->transferToBillomat();

        $creditNote->completeCreditNote();

        $creditNote->storePDF();

        $creditNote->save();
    }
}
