<?php

namespace App\Observer;

use App\AbstractModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;

/**
 * Observer to  Update the timestamp in the named update column i.e.
 *
 * status_STATUSNAME_at
 */
class ModelStatusObserver
{

    protected function updateTimestamp($model) {
        $updatedColumn = 'status_' . strtolower($model->status) . '_at';
        if (!Schema::hasColumn($model->getTable(), $updatedColumn)) {
            return;
        }
        $model->$updatedColumn = $model->freshTimestamp();
        Log::notice(sprintf('Setting status for %s ID %d to %s', get_class($model), $model->id, $model->status));
    }

    public function updating(Model $model) {
        if (!Schema::hasColumn($model->getTable(), 'status')) {
            return;
        }
        if ($model->isDirty('status')) {
            if ($model->original['status'] != $model->status) {
                $this->updateTimestamp($model);
            }
        }
    }

    public function creating(Model $model) {
        $this->updateTimestamp($model);
    }
}