<?php

namespace App\Notifications\Telegram;


use GuzzleHttp\Client as GuzzleClient;

class Notification
{
    private $guzzleClient;

    /**
     * Message data.
     *
     * @var mixed
     */
    protected $data;

    /**
     * Prepared message.
     *
     * @var string
     */
    protected $message;

    /**
     * Notification constructor.
     * @param $data
     */
    public function __construct($data)
    {
        $this->data    = $data;
        $this->message = $this->prepareData();

        $this->guzzleClient = new GuzzleClient();
    }

    /**
     * Method to prepare data to sending.
     *
     * @return string
     */
    protected function prepareData()
    {
        return (string)$this->data;
    }

    /**
     * Method to send data to Telegram channel.
     */
    public function send()
    {
        $this->guzzleClient->request('POST', 'https://api.telegram.org/bot' . config('services.telegram_err_handler.bot_token') . '/sendMessage', [
            'form_params' => [
                'chat_id'    => config('services.telegram_err_handler.channel_id'),
                'text'       => $this->message,
            ],
        ]);
    }
}