<?php

namespace App\Notifications\Telegram;


use App\Services\UserAgentService;

class ExceptionThrownNotification extends Notification
{
    /**
     * Method to prepare data to sending.
     *
     * @return string
     */
    protected function prepareData()
    {
        if ( !($this->data instanceof \Exception) ) {
            return '';
        }

        $data = [
            'Error message: ' . $this->data->getMessage(),
            'File: ' . $this->data->getFile(),
            'String: ' . $this->data->getLine(),
            'Error code: ' . $this->data->getCode(),
            'Error type: ' . get_class($this->data),
            'Request URL: ' . request()->server('REQUEST_URI'),
            'Request method: ' . request()->method(),
            'User ID: ' . (request()->user() ? request()->user()->id : 'unauthorized'),
            'IP address: ' . request()->ip(),
            'Device: ' . (new UserAgentService(request()->header('User-Agent')))->getLogString(),
        ];

        return implode(PHP_EOL, $data);
    }
}