<?php

namespace App\Notifications\Mail;

use Illuminate\Support\Facades\Mail;

class Notification
{
    protected $senderEmail    = 'no-reply@reco.ma';
    protected $senderName     = 'RECO.MA GmbH';
    protected $templateData   = null;
    protected $subject        = null;
    protected $recipientEmail = null;
    protected $recipientName  = null;
    protected $returnEmail    = 'no-reply@reco.ma';
    protected $replyEmail     = 'no-reply@reco.ma';
    protected $replyName      = 'RECO.MA GmbH';

    /**
     * Method to set template data.
     *
     * @param $templateData
     * @return Notification
     */
    public function setTemplateData($templateData)
    {
        $this->templateData = $templateData;

        return $this;
    }

    /**
     * Method to set subject.
     *
     * @param $subject
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * Method to set recipient.
     *
     * @param string $recipientEmail
     * @param string $recipientName
     * @return Notification
     */
    public function setRecipient($recipientEmail, $recipientName = '')
    {
        $this->recipientEmail = $recipientEmail;
        $this->recipientName  = $recipientName;

        return $this;
    }

    /**
     * Method to set reply recipient.
     *
     * @param string $replyEmail
     * @param string $replyName
     * @return $this
     */
    public function setReply($replyEmail, $replyName = '')
    {
        $this->replyEmail = $replyEmail;
        $this->replyName  = $replyName;

        return $this;
    }

    /**
     * Method to set sender.
     *
     * @param $senderEmail
     * @param $senderName
     * @return $this
     */
    public function setSender($senderEmail, $senderName)
    {
        $this->senderEmail = $senderEmail;
        $this->senderName  = $senderName;

        return $this;
    }

    /**
     * Method to send notification.
     *
     * @return mixed
     */
    public function send()
    {
        return Mail::queue($this->template, $this->templateData, function ($message) {
            $message->subject($this->subject);
            $message->sender($this->senderEmail, $this->senderName);
            $message->from($this->senderEmail, $this->senderName);
            $message->to($this->recipientEmail, $this->recipientName);
            $message->returnPath($this->returnEmail);
            $message->replyTo($this->replyEmail, $this->replyName);
        });
    }
}