<?php

namespace App\Listeners;

use App\Events\CouponFinishedSellerTransactions;
use App\CouponTemplate;
use App\Services\UsersGiftService;

class UsersGiftSetPaid
{
    /**
     * Handle the event.
     *
     * @param  CouponFinishedSellerTransactions  $event
     * @return void
     */
    public function handle(CouponFinishedSellerTransactions $event)
    {
        $coupon = $event->coupon;

        if (CouponTemplate::TYPE_GIFT === $coupon->type_provision) {
            (new UsersGiftService())->setPaid($coupon->provision_gift_id, $coupon->agent_user_id, $coupon->id);
        }

        if (CouponTemplate::TYPE_GIFT === $coupon->type_discount) {
            (new UsersGiftService())->setPaid($coupon->discount_gift_id, $coupon->consumer_user_id, $coupon->id);
        }
    }
}
